"""Pomocné funkce pro práci se slovníkem ve slovním fotbalu."""

Slovnik = dict[str, set[str]]


def prvni_pismeno(slovo: str | None) -> str:
    """Vrátí první písmeno slova. 'Ch' je považováno za jedno písmeno."""
    if slovo is None:
        return ""
    if slovo.startswith('ch'):
        return 'ch'
    return slovo[0]


def posledni_pismeno(slovo: str | None) -> str:
    """Vrátí poslední písmeno slova. 'Ch' je považováno za jedno písmeno."""
    if slovo is None:
        return ""
    if slovo.endswith('ch'):
        return 'ch'
    return slovo[-1]


def nacti_slovnik(cesta: str) -> tuple[Slovnik, Slovnik]:
    """
    Načte slovník ze souboru a rozdělí slova podle prvního a posledního písmene.
    Vrátí dvojici (slova_podle_zacatku, slova_podle_konce).
    """
    slova_podle_zacatku: Slovnik = {}
    slova_podle_konce: Slovnik = {}

    with open(cesta, 'r', encoding='utf-8') as soubor:
        for radek in soubor:
            slovo = radek.strip().lower()
            slova_podle_zacatku.setdefault(prvni_pismeno(slovo), set()).add(slovo)
            slova_podle_konce.setdefault(posledni_pismeno(slovo), set()).add(slovo)

    return slova_podle_zacatku, slova_podle_konce
