"""Slovní fotbal - interaktivní hra člověka proti počítači."""
import random
import sys

from slovni_pomucky import nacti_slovnik, posledni_pismeno, prvni_pismeno

# Hráč 0 je člověk, ostatní hráči jsou počítač
POCET_HRACU = 2
VYCHOZI_CESTA_K_SLOVNIKU = 'inputs_hra/mnoho.txt'

cesta_k_slovniku: str = sys.argv[1] if len(sys.argv) > 1 else VYCHOZI_CESTA_K_SLOVNIKU
SLOVNIK, _slova_dle_posledniho = nacti_slovnik(cesta_k_slovniku)


def tah_cloveka(aktualni_slovo: str | None, pouzita: set[str]) -> str | None:
    """Vyzve hráče k zadání slova. Vrátí None pokud se vzdá (zadá 0)."""
    zadane: str | None = None
    predchozi_konec = posledni_pismeno(aktualni_slovo)
    while (zadane is None
           or (zadane != "0" and aktualni_slovo is not None
               and predchozi_konec != prvni_pismeno(zadane))
           or zadane in pouzita):
        zadane = input(f"Zadej slovo na '{predchozi_konec}': ").strip().lower()
        if zadane == "0" or len(zadane) == 0:
            return None
    return zadane


def tah_pocitace(aktualni_slovo: str | None, herni_slovnik: dict[str, set[str]]) -> str | None:
    """Vybere slovo ze slovníku navazující na aktualni_slovo. Vrátí None pokud nemá co hrát."""
    pocatecni_pismeno = posledni_pismeno(aktualni_slovo)
    if pocatecni_pismeno not in herni_slovnik or len(herni_slovnik[pocatecni_pismeno]) == 0:
        return None
    # sorted() zajistí náhodný výběr (set.pop() by byl rychlejší, ale nedeterministický)
    return random.choice(sorted(herni_slovnik[pocatecni_pismeno]))


def hraj() -> None:
    """Hlavní smyčka hry."""
    print("Vítej ve hře slovního fotbalu")
    print("Napiš 0 pokud se chceš vzdát")
    print("=" * 30)

    hrac: int = 0
    posledni_slovo: str | None = None
    pouzita_slova: set[str] = set()
    slovo: str | None = None

    while True:
        if hrac == 0:
            slovo = tah_cloveka(posledni_slovo, pouzita_slova)
        else:
            slovo = tah_pocitace(posledni_slovo, SLOVNIK)
            if slovo is None:
                print(f"Hráč {hrac} nemá žádné slovo = KONEC")
                break

        if slovo is None:
            print(f"Hráč {hrac} se vzdává = KONEC")
            break

        SLOVNIK[prvni_pismeno(slovo)].discard(slovo)
        pouzita_slova.add(slovo)
        print(f"Hráč {hrac}: {slovo}")
        posledni_slovo = slovo

        hrac = (hrac + 1) % POCET_HRACU


hraj()
