# defrag

Jednoduchý průvodce pro spuštění projektu defragmentace.

## Požadavky

Nainstaluj [Rust](https://rustup.rs/) – stačí spustit:

```bash
curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh
```

Po instalaci ověř, že vše funguje:

```bash
rustc --version
cargo --version
```

---

## Spuštění

### Hlavní program (`defrag`)

```bash
cargo run --bin defrag
```

Chceš předat argumenty? Přidej `--` před ně:

```bash
cargo run --bin defrag -- --help
```

```bash
cargo run --bin defrag -- input/01/A.txt
```

### Generátor dat (`gen`)

```bash
cargo run --bin gen
```

---

## Sestavení (build)

```bash
cargo build          # debug verze (rychlejší kompilace)
cargo build --release  # optimalizovaná verze (pomalejší kompilace, rychlejší program)
```

Výsledné binárky najdeš v:
- `target/debug/defrag`
- `target/release/defrag`

---

## Testy a benchmarky

```bash
cargo test           # spustí všechny testy
cargo bench          # spustí benchmarky (výsledky uloží do target/criterion/)
```

---

## Logování

Program používá `env_logger`. Úroveň logů nastavíš přes proměnnou prostředí:

```bash
RUST_LOG=debug cargo run --bin defrag
RUST_LOG=info  cargo run --bin defrag
```

---

## Časté problémy

| Problém | Řešení |
|---|---|
| `error: linker not found` | Nainstaluj `gcc` nebo `clang` |
| `cargo: command not found` | Přidej `~/.cargo/bin` do `PATH` |
| Pomalá první kompilace | Normální – závislosti se stahují jen poprvé |
