use clap::Parser;
use lib::{Error, defrag};
use std::fs::File;
use std::io::stdout;
use std::path::PathBuf;

#[derive(Parser)]
struct Args {
    input: PathBuf,
    output: Option<PathBuf>,
}

fn main() {
    let args = Args::parse();
    match if let Some(output_path) = args.output {
        defrag(args.input.as_path(), &mut File::create(output_path).unwrap())
    } else {
        defrag(args.input.as_path(), &mut stdout())
    } {
        Err(Error::Logic(stack)) => {
            eprintln!("Loop detected: ");
            let last = stack.last().expect("Impossible");
            let first = stack.iter().position(|x| x == last).expect("Impossible");
            for path in &stack[first..] {
                eprintln!(" * {}", path.as_os_str().to_str().unwrap());
            }
        }
        Err(Error::IO(err)) => {
            eprintln!("IO error: {err}");
        }
        _ => {}
    }
}
