use criterion::{Criterion, criterion_group, criterion_main};
use lib::{defrag, defrag_simple};
use std::fs::File;
use std::hint::black_box;
use std::path::PathBuf;

fn bench_deep(c: &mut Criterion) {
    for input_idx in 1..=6 {
        let input: PathBuf =
            black_box(format!("/home/luso/Projects/soutez/2026_OK/defrag/input/{input_idx:02}/A.txt").into());
        let output: PathBuf = black_box("/tmp/out.txt".into());

        c.bench_function(format!("defrag cached {input_idx:02}").as_str(), |b| {
            b.iter(|| defrag(input.as_path(), &mut File::create(&output).unwrap()))
        });

        c.bench_function(format!("defrag simple {input_idx:02}").as_str(), |b| {
            b.iter(|| defrag_simple(input.as_path(), &mut File::create(&output).unwrap()))
        });
    }
}

criterion_group!(
    name = benches;
    config = Criterion::default().sample_size(50);
    targets = bench_deep
);
criterion_main!(benches);
